local assets =
{
    Asset("ANIM", "anim/hat_roncat.zip"),
    Asset("ANIM", "anim/hat_roncat_anim.zip"),
	Asset("ATLAS", "images/inventoryimages/roncathat.xml"),
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_hat", "hat_roncat", "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Show("HAT_HAIR")
	owner.AnimState:Hide("HAIR_NOHAT")
	owner.AnimState:Hide("HAIR")

	if owner:HasTag("player") then
		owner.AnimState:Hide("HEAD")
		owner.AnimState:Show("HEAD_HAIR")
	end
	
	owner:AddTag("roncatgoldfinder") -- Find random gold
	
	if inst.components.fueled then
		inst.components.fueled:StartConsuming()
	end
end

local function onunequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_hat")
	owner.AnimState:Hide("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")

	if owner:HasTag("player") then
		owner.AnimState:Show("HEAD")
		owner.AnimState:Hide("HEAD_HAIR")
	end
	
	owner:RemoveTag("roncatgoldfinder")

	if inst.components.fueled then
		inst.components.fueled:StopConsuming()
	end
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
    inst.AnimState:SetBank("hat_roncat")
    inst.AnimState:SetBuild("hat_roncat")
    inst.AnimState:PlayAnimation("idle")

    MakeInventoryPhysics(inst)
	if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "idle_water", "idle")
	end
	
    inst:AddTag("hat")
	inst:AddTag("roncatluckywear") -- Prevents jinx when equipping
	
    inst:AddComponent("inspectable")
	
    inst:AddComponent("tradable")

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	
	if IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC) then
		inst.components.equippable.dapperness = TUNING.DAPPERNESS_MED
		inst:AddComponent("waterproofer")
		inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)
	else
		inst:AddComponent("dapperness")
		inst.components.dapperness.dapperness = TUNING.DAPPERNESS_MED
	end

    inst:AddComponent("inventoryitem")
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/roncathat.xml"
	
	inst:AddComponent("fueled")
	inst.components.fueled.fueltype = "USAGE"
	inst.components.fueled:InitializeFuelLevel(TUNING.TOPHAT_PERISHTIME/2)
	inst.components.fueled:SetDepletedFn(inst.Remove)
	
	

    return inst
end


return Prefab("common/inventory/roncathat", fn, assets)
